<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>
<div class="container py-5" style="background: linear-gradient(135deg, #87CEEB 0%, #4169E1 100%); min-height: 100vh;">
    <div class="row">
        <div class="col-12">
            <!-- Header Section -->
            <div class="text-center mb-5">
                <div class="d-inline-flex align-items-center justify-content-center bg-white rounded-circle shadow-lg mb-4" style="width: 80px; height: 80px;">
                    <i class="bi bi-briefcase text-primary" style="font-size: 2.5rem;"></i>
                </div>
                <h1 class="display-4 fw-bold text-white mb-3">Pengalaman Kerja</h1>
                <p class="lead text-white opacity-90">Perjalanan karir dan pengalaman profesional</p>
            </div>

            <!-- Work Experience Timeline -->
            <?php if (empty($work)): ?>
                <div class="card shadow-lg border-0 text-center py-5" style="background: rgba(255, 255, 255, 0.95);">
                    <div class="card-body">
                        <i class="bi bi-info-circle text-primary mb-3" style="font-size: 3rem;"></i>
                        <h4 class="text-primary">Tidak ada pengalaman kerja yang ditemukan</h4>
                        <p class="text-muted">Belum ada data pengalaman kerja yang tersedia.</p>
                    </div>
                </div>
            <?php else: ?>
                <div class="row g-4">
                    <?php foreach ($work as $w): ?>
                        <div class="col-12">
                            <div class="card shadow-lg border-0" style="background: rgba(255, 255, 255, 0.95); backdrop-filter: blur(10px);">
                                <div class="card-body p-4">
                                    <div class="row align-items-start">
                                        <div class="col-md-8">
                                            <div class="d-flex align-items-center mb-3">
                                                <div class="bg-primary rounded-circle p-3 me-3">
                                                    <i class="bi bi-briefcase-fill text-white" style="font-size: 1.5rem;"></i>
                                                </div>
                                                <div>
                                                    <h4 class="text-primary fw-bold mb-1"><?= esc($w['posisi']) ?></h4>
                                                    <p class="text-muted mb-0">
                                                        <i class="bi bi-building me-1"></i><?= esc($w['nama_perusahaan']) ?>
                                                    </p>
                                                </div>
                                            </div>
                                            <?php if ($w['deskripsi']): ?>
                                                <div class="ms-5 ps-2">
                                                    <p class="text-dark mb-0"><?= nl2br(esc($w['deskripsi'])) ?></p>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                        <div class="col-md-4 text-md-end">
                                            <?php if ($w['tahun_mulai'] && $w['tahun_selesai']): ?>
                                                <div class="badge bg-primary fs-6 px-3 py-2">
                                                    <i class="bi bi-calendar-range me-1"></i>
                                                    <?= esc($w['tahun_mulai']) ?> - <?= esc($w['tahun_selesai']) ?>
                                                </div>
                                            <?php elseif ($w['tahun_mulai']): ?>
                                                <div class="badge bg-success fs-6 px-3 py-2">
                                                    <i class="bi bi-calendar me-1"></i>
                                                    Mulai: <?= esc($w['tahun_mulai']) ?>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>

                <!-- Pagination -->
                <?php if (isset($lastPage) && $lastPage > 1): ?>
                    <div class="row mt-5">
                        <div class="col-12">
                            <nav aria-label="Page navigation">
                                <ul class="pagination justify-content-center">
                                    <?php if ($currentPage > 1): ?>
                                        <li class="page-item">
                                            <a class="page-link" href="<?= base_url('work?page=' . ($currentPage - 1) . '&search=' . urlencode($search) . '&tahun_mulai=' . urlencode($filter['tahun_mulai']) . '&tahun_selesai=' . urlencode($filter['tahun_selesai']) . '&sort=' . $sort . '&order=' . $order) ?>">
                                                <i class="bi bi-chevron-left"></i> Sebelumnya
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                    
                                    <?php for ($i = 1; $i <= $lastPage; $i++): ?>
                                        <li class="page-item <?= $i == $currentPage ? 'active' : '' ?>">
                                            <a class="page-link" href="<?= base_url('work?page=' . $i . '&search=' . urlencode($search) . '&tahun_mulai=' . urlencode($filter['tahun_mulai']) . '&tahun_selesai=' . urlencode($filter['tahun_selesai']) . '&sort=' . $sort . '&order=' . $order) ?>">
                                                <?= $i ?>
                                            </a>
                                        </li>
                                    <?php endfor; ?>
                                    
                                    <?php if ($currentPage < $lastPage): ?>
                                        <li class="page-item">
                                            <a class="page-link" href="<?= base_url('work?page=' . ($currentPage + 1) . '&search=' . urlencode($search) . '&tahun_mulai=' . urlencode($filter['tahun_mulai']) . '&tahun_selesai=' . urlencode($filter['tahun_selesai']) . '&sort=' . $sort . '&order=' . $order) ?>">
                                                Selanjutnya <i class="bi bi-chevron-right"></i>
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </nav>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

